<?php

namespace App\Http\Controllers;

use App\Models\Agenda;
use App\Models\Berita;
use App\Models\Galeri;
use App\Models\Informasipublik;
use App\Models\InformasipublikKategori;
use App\Models\Menu;
use App\Models\Patner;
use App\Models\Perangkat;
use App\Models\Profil;
use App\Models\Slider;
use App\Models\Sosmed;
use App\Models\Sotk;
use App\Models\Visimisi;
use Illuminate\Http\Request;

class GuestController extends Controller
{
    public function index(){
        $menus = Menu::where('kode_induk', NULL)->orderBy('urutan')->get();
        $sliders = Slider::where('status', 'aktif')->orderBy('id','DESC')->get();
        $profil = Profil::where('pt_id', 1)->first();
        $patners = Patner::all();
        $sosmeds = Sosmed::where('jenis', 'sosmed')->get();
        $websites = Sosmed::where('jenis', 'website')->get();
        $beritas = Berita::orderBy('id','DESC')->paginate(6);
        $berita_beranda = Berita::orderBy('id','DESC')->limit(4)->get();
        $berita_side = Berita::orderBy('baca', 'DESC')->limit(4)->get();
        $galeris = Galeri::orderBy('id','DESC')->paginate(6);
        $galeri_beranda = Galeri::orderBy('id','DESC')->limit(4)->get();
        $per_desa = Perangkat::where('kelompok','desa')->get();
        $per_bpd = Perangkat::where('kelompok','bpd')->get();
        $per_pkk = Perangkat::where('kelompok','pkk')->get();
        $per_karangtaruna = Perangkat::where('kelompok','karangtaruna')->get();
        $agendas = Agenda::orderBy('id','DESC')->paginate(5);
        $agenda_beranda = Agenda::where('jenis', 'Agenda Desa')->orderBy('id','DESC')->limit(3)->get();
        $sotk = Sotk::orderBy('id', 'DESC')->first();
        return view('guest.index',[
            'menus' => $menus,
            'sliders' => $sliders,
            'profil' => $profil,
            'patners' => $patners,
            'sosmeds' => $sosmeds,
            'websites' => $websites,
            'beritas' => $beritas,
            'berita_beranda' => $berita_beranda,
            'berita_side' => $berita_side,
            'galeris' => $galeris,
            'galeri_beranda' => $galeri_beranda,
            'per_desa' => $per_desa,
            'per_bpd' => $per_bpd,
            'per_pkk' => $per_pkk,
            'per_karangtaruna' => $per_karangtaruna,
            'agendas' => $agendas,
            'agenda_beranda' => $agenda_beranda,
            'sotk' => $sotk,
        ])->with('tittle', 'Beranda');
    }
    public function page($alamat){
        if($alamat=="apbdes" || $alamat=="lppd"){
            $halaman = "informasipublik";
        }elseif($alamat=="pengumuman" || $alamat=="potensi-desa" || $alamat=="kontak-kami"){
            $halaman = "404";
        }else{
            $halaman = $alamat;
        }
        $menus = Menu::where('kode_induk', NULL)->orderBy('urutan')->get();
        $sliders = Slider::where('status', 'aktif')->orderBy('id','DESC')->get();
        $profil = Profil::where('pt_id', 1)->first();
        $patners = Patner::all();
        $sosmeds = Sosmed::where('jenis', 'sosmed')->get();
        $websites = Sosmed::where('jenis', 'website')->get();
        $beritas = Berita::orderBy('id','DESC')->paginate(6);
        $berita_beranda = Berita::orderBy('id','DESC')->limit(4)->get();
        $berita_side = Berita::orderBy('baca', 'DESC')->limit(4)->get();
        $galeris = Galeri::orderBy('id','DESC')->paginate(6);
        $galeri_beranda = Galeri::orderBy('id','DESC')->limit(4)->get();
        $galeri_side = Galeri::limit(4)->get();
        $per_desa = Perangkat::where('kelompok','desa')->get();
        $per_bpd = Perangkat::where('kelompok','bpd')->get();
        $per_pkk = Perangkat::where('kelompok','pkk')->get();
        $per_karangtaruna = Perangkat::where('kelompok','karangtaruna')->get();
        $agendas = Agenda::orderBy('id','DESC')->paginate(5);
        $agenda_beranda = Agenda::where('jenis', 'Agenda Desa')->orderBy('id','DESC')->limit(3)->get();
        $sotk = Sotk::orderBy('id', 'DESC')->first();
        $visi = Visimisi::where('jenis','Visi')->orderBy('id','DESC')->first();
        $misis = Visimisi::where('jenis','Misi')->orderBy('id','DESC')->get();
        $kategori = InformasipublikKategori::where('slug_nama', $alamat)->first();
        return view('guest.'.$halaman.'.index',[
            'menus' => $menus,
            'sliders' => $sliders,
            'profil' => $profil,
            'patners' => $patners,
            'sosmeds' => $sosmeds,
            'websites' => $websites,
            'beritas' => $beritas,
            'berita_beranda' => $berita_beranda,
            'berita_side' => $berita_side,
            'galeris' => $galeris,
            'galeri_beranda' => $galeri_beranda,
            'galeri_side' => $galeri_side,
            'per_desa' => $per_desa,
            'per_bpd' => $per_bpd,
            'per_pkk' => $per_pkk,
            'per_karangtaruna' => $per_karangtaruna,
            'agendas' => $agendas,
            'agenda_beranda' => $agenda_beranda,
            'sotk' => $sotk,
            'visi' => $visi,
            'misis' => $misis,
            'kategori' => $kategori,
        ])->with('tittle', strtoupper($alamat));
    }

    public function berita(){
        $menus = Menu::where('kode_induk', NULL)->orderBy('urutan')->get();
        $profil = Profil::where('pt_id', 1)->first();
        $patners = Patner::all();
        $sosmeds = Sosmed::all();
        $berita = Berita::limit(4)->get();
        $datas = Berita::all();
        return view('guest.berita.index',[
            'menus' => $menus,
            'profil' => $profil,
            'patners' => $patners,
            'sosmeds' => $sosmeds,
            'berita' => $berita,
            'datas' => $datas,
        ])->with('tittle', 'Berita Terkini');
    }

    public function berita_detail($slug){
        $menus = Menu::where('kode_induk', NULL)->orderBy('urutan')->get();
        $profil = Profil::where('pt_id', 1)->first();
        $patners = Patner::all();
        $sosmeds = Sosmed::where('jenis', 'sosmed')->get();
        $websites = Sosmed::where('jenis', 'website')->get();
        $berita_side = Berita::limit(4)->get();
        $galeri_side = Galeri::limit(4)->get();
        $data = Berita::where('slug_judul', $slug)->first();
        //update baca
        $baca = $data->baca+1;
        $update = Berita::where('slug_judul', $slug)->update([
            'baca' => $baca
        ]);
        return view('guest.berita.detail',[
            'menus' => $menus,
            'profil' => $profil,
            'patners' => $patners,
            'sosmeds' => $sosmeds,
            'websites' => $websites,
            'berita_side' => $berita_side,
            'galeri_side' => $galeri_side,
            'data' => $data,
        ])->with('tittle', 'Berita');
    }

    // public function galeri(){
    //     $menus = Menu::where('kode_induk', NULL)->orderBy('urutan')->get();
    //     $profil = Profil::where('pt_id', 1)->first();
    //     $patners = Patner::all();
    //     $sosmeds = Sosmed::all();
    //     $galeri = Galeri::limit(4)->get();
    //     $datas = Galeri::all();
    //     return view('guest.galeri.index',[
    //         'menus' => $menus,
    //         'profil' => $profil,
    //         'patners' => $patners,
    //         'sosmeds' => $sosmeds,
    //         'galeri' => $galeri,
    //         'datas' => $datas,
    //     ])->with('tittle', 'Galeri Desa');
    // }

    public function galeri_detail($slug){
        $menus = Menu::where('kode_induk', NULL)->orderBy('urutan')->get();
        $profil = Profil::where('pt_id', 1)->first();
        $patners = Patner::all();
        $sosmeds = Sosmed::where('jenis', 'sosmed')->get();
        $websites = Sosmed::where('jenis', 'website')->get();
        $berita_side = Berita::limit(4)->get();
        $galeri_side = Galeri::limit(4)->get();
        $data = Galeri::where('slug_judul', $slug)->first();
        $fotos = json_decode($data->foto);
        return view('guest.galeri.detail',[
            'menus' => $menus,
            'profil' => $profil,
            'patners' => $patners,
            'sosmeds' => $sosmeds,
            'websites' => $websites,
            'galeri_side' => $galeri_side,
            'berita_side' => $berita_side,
            'data' => $data,
            'fotos' => $fotos,
        ])->with('tittle', 'Galeri Desa');
    }
}
