@extends('admin.layouts.master')
@section('css')
<link href="https://cdn.datatables.net/1.13.1/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-beta.1/css/select2.min.css" rel="stylesheet" />
{{-- <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0/dist/css/select2.min.css" rel="stylesheet" /> --}}
<style>
    .select2-container {
    width: 100% !important; 
}
</style>
@endsection
@section('content')
<!--begin::Toolbar-->
<div class="toolbar mt-2" id="kt_toolbar">
    <!--begin::Container-->
    <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
        <!--begin::Page title-->
        <div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
            <!--begin::Title-->
            <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">{{ $tittle }}</h1>
            <!--end::Title-->
            <!--begin::Separator-->
            <span class="h-20px border-gray-300 border-start mx-4"></span>
            <!--end::Separator-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="{{ route('admin-dashboard') }}" class="text-muted text-hover-primary">Beranda</a>
                </li>
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-300 w-5px h-2px"></span>
                </li>
                <li class="breadcrumb-item text-muted">{{ $tittle }}</li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
    </div>
</div>
<!--begin::Post-->
<div class="post d-flex flex-column-fluid mt-0">
    <!--begin::Container-->
    <div class="container">
        <!--begin::Pricing card-->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">List {{ $tittle }}</span>
                </h3>
                <div class="card-toolbar">
                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#addKkModal" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tambah</a>
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5 align-center">
                <table id="kks-table" class="table table-striped table-row-bordered gy-4 gs-7 border rounded">
                    <thead>
                        <tr class="fw-bolder bg-secondary fs-6 text-gray-800 px-7">
                            <th width="7%" class="align-middle">No</th>
                            <th class="align-middle text-center" width="10%">Opsi</th>
                            <th class="align-middle"width="30%">No KK</th>
                            <th class="align-middle"width="30%">KEPALA KK</th>
                            <th class="align-middle text-center">JML. Anggota KK</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- Modal Add -->
@include('admin.kependudukan.kk.item.add')
<!-- Modal Update -->
<div class="modal fade" id="updateKkModal" tabindex="-1" aria-labelledby="updateKkModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="" method="POST" id="updateKkForm">
                @csrf
                @method('PUT')
                <div class="modal-header">
                    <h5 class="modal-title" id="updateKkModalLabel">Edit Data KK</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="update_no_kk" class="form-label">Nomor KK</label>
                        <input type="text" class="form-control" id="update_no_kk" name="id" required maxlength="16">
                    </div>
                    <div class="mb-3">
                        <label for="update_kepala_kk" class="form-label">NIK Kepala Keluarga</label><br>
                        <select class="form-control select2" id="update_kepala_kk" name="kepala_kk" required>
                            <option value="">Pilih NIK Kepala Keluarga</option>
                            @foreach($penduduks as $penduduk)
                                <option value="{{ $penduduk->id }}">{{ $penduduk->id }} - {{ $penduduk->nama_lengkap }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Delete -->
<div class="modal fade" id="deleteKkModal" tabindex="-1" aria-labelledby="deleteKkModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="" method="POST" id="deleteKkForm">
                @csrf
                @method('DELETE') <!-- Menggunakan metode DELETE untuk penghapusan -->
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteKkModalLabel">Hapus Data KK</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Apakah Anda yakin ingin menghapus data KK ini?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-danger">Hapus</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection
@section('js')
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/dataTables.bootstrap5.min.js"></script>

{{-- <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0/dist/js/select2.min.js"></script> --}}
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-beta.1/js/select2.min.js"></script>

<script type="text/javascript">

    $('#addKkModal').on('shown.bs.modal', function() {
        $('#kepala_kk').select2({
            dropdownParent: $('#addKkModal')
        });
    });

    $(document).ready(function() {
        $('#kks-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('admin-kependudukan-get-kks') }}",
            columns: [
                { data: 'DT_RowIndex', name: 'DT_RowIndex', className: 'align-middle', orderable: false, searchable: false },
                { data: 'opsi', name: 'opsi', className: 'text-center align-middle', orderable: false, searchable: false },
                { data: 'id', name: 'id', className: 'align-middle' },
                { data: 'nik_nama_kepala', name: 'nik_nama_kepala', className: 'align-middle' },
                { data: 'total', name: 'total', className: 'text-center align-middle' } 
            ]
        });

        // Handle edit button click
        $('#kks-table').on('click', '.edit-kk', function() {
            var id = $(this).data('id');
            var url = "{{ route('admin-kependudukan-get-kk-id', ':id') }}";
            url = url.replace(':id', id);

            $.get(url, function(data) {
                $('#update_no_kk').val(data.id);
                $('#update_kepala_kk').val(data.kepala_kk).trigger('change');
                $('#updateKkForm').attr('action', "{{ route('admin-kependudukan-kk-update', ':id') }}".replace(':id', id));
                $('#updateKkModal').modal('show');
            });
        });

        // Inisialisasi Select2 untuk form update
        $('#update_kepala_kk').select2({
            dropdownParent: $('#updateKkModal')
        });

        // Klik tombol delete
        $('#kks-table').on('click', '.delete-kk', function() {
            var id = $(this).data('id');
            var url = "{{ route('admin-kependudukan-kk-delete', ':id') }}";
            url = url.replace(':id', id);

            // Set action form delete ke URL yang sesuai
            $('#deleteKkForm').attr('action', url);

            // Menampilkan modal delete
            $('#deleteKkModal').modal('show');
        });
    });
</script>
@endsection