@extends('guest.layouts.master')
@section('css')
@endsection
@section('content')
<div class="hero page-inner overlay"style="background-image: url({{ asset('guest/images/hero_bg_3.jpg') }})">
    <div class="container">
      <div class="row justify-content-center align-items-center">
        <div class="col-lg-9 text-center mt-5">
          <h1 class="heading" data-aos="fade-up">{{ $tittle }}</h1>
          <nav aria-label="breadcrumb"data-aos="fade-up"data-aos-delay="200">
            <ol class="breadcrumb text-center justify-content-center">
              <li class="breadcrumb-item"><a href="{{ route('beranda') }}">Beranda</a></li>
              <li class="breadcrumb-item active text-white-50"aria-current="page">{{ $tittle }}</li>
            </ol>
          </nav>
        </div>
      </div>
    </div>
</div>
<div class="section">
  <div class="container">
    <div class="row justify-content-between mb-5">
        <div class="col-lg-8 mb-5 mb-lg-0">
          <h3>VISI MISI {{ $profil->nama }}</h3>
          <div class="specs d-flex mb-4">
            <span class="d-block d-flex align-items-center me-3">
              <span class="icon-user me-2"></span>
              <span class="caption">Admin</span>
            </span>
            {{-- <span class="d-block d-flex align-items-center">
              <span class="icon-clock-o me-2"></span>
              <span class="caption">{{ date('d M Y h:s', strtotime($sotk?->created_at)) }}</span>
            </span> --}}
          </div>
          <div class="row">
            <div class="col-md-12 mb-3">
              <div class="card">
                <div class="card-header">
                  <span class="card-title fs-3 text-dark">VISI</span>
                </div>
                <div class="card-body text-center">
                  <h3>"{{ $visi?->isi_visimisi }}"</h3>
                </div>
              </div>
            </div>
            <div class="col-md-12">
              <div class="card">
                <div class="card-header">
                  <span class="card-title fs-3 text-dark">MISI</span>
                </div>
                <div class="card-body">
                  @php
                      $no=1;
                  @endphp
                  @foreach ($misis as $misi)
                      <p class="text-dark fs-6">{{ $no++ }}. {{ $misi->isi_visimisi }}</p>
                  @endforeach
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-lg-4">
          @include('guest.item.side.populer')
          @include('guest.item.side.galeri')
        </div>
    </div>
  </div>
</div>
@endsection
@section('js')
@endsection