<?php
    use App\Models\Menu;
?>

<?php $__env->startSection('css'); ?>
<link href="https://cdn.datatables.net/1.13.1/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!--begin::Toolbar-->
<div class="toolbar mt-2" id="kt_toolbar">
    <!--begin::Container-->
    <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
        <!--begin::Page title-->
        <div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
            <!--begin::Title-->
            <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1"><?php echo e($tittle); ?></h1>
            <!--end::Title-->
            <!--begin::Separator-->
            <span class="h-20px border-gray-300 border-start mx-4"></span>
            <!--end::Separator-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="<?php echo e(route('admin-dashboard')); ?>" class="text-muted text-hover-primary"><?php echo e($tittle); ?></a>
                </li>
                <!--end::Item-->
                <!--begin::Item-->
                <li class="breadcrumb-item">
                    
                </li>
                <!--end::Item-->
                <!--begin::Item-->
                
                <!--end::Item-->
                <!--begin::Item-->
                <li class="breadcrumb-item">
                    
                </li>
                <!--end::Item-->
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">Navbar</li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
    </div>
</div>
<!--begin::Post-->
<div class="post d-flex flex-column-fluid mt-0">
    <!--begin::Container-->
    <div class="container">
        <!--begin::Pricing card-->
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">List Navbar</span>
                </h3>
                <div class="card-toolbar">
                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#store" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tambah</a>
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <table id="datatable" class="table table-striped table-row-bordered gy-4 gs-7 border rounded">
                    <thead>
                        <tr class="fw-bolder bg-secondary fs-6 text-gray-800 px-7">
                            <th width="7%" class="align-middle">No</th>
                            <th class="align-middle">Navbar</th>
                            <th class="align-middle">Navbar Induk</th>
                            <th class="align-middle text-center">Link</th>
                            <th class="align-middle text-center">Urutan</th>
                            <th class="align-middle text-center">status</th>
                            <th class="align-middle text-center" width="10%">Opsi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            if($data?->kode_induk==NULL){
                                $nama_induk = '-';
                            }else{
                                $induk = Menu::where('id', $data?->kode_induk)->first();
                                $nama_induk = $induk?->nama;
                            }
                            if($data?->status=='aktif'){
                                $warna = 'success';
                                $value = 'tidak';
                            }else{
                                $warna = 'danger';
                                $value = 'aktif';
                            }
                        ?>
                            <tr>
                                <td class="align-middle"><?php echo e($loop->iteration); ?></td>
                                <td class="align-middle"><?php echo e(strtoupper($data?->nama)); ?></td>
                                <td class="align-middle"><?php echo e($nama_induk); ?></td>
                                <td class="align-middle"><?php echo e($data?->alamat_link ? $data?->alamat_link : '-'); ?></td>
                                <td class="align-middle text-center"><?php echo e($data?->urutan); ?></td>
                                <td class="align-middle text-center">
                                    <form action="<?php echo e(route('admin-menu-status',['id' => $data?->id])); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="status" value="<?php echo e($value); ?>">
                                        <button type="submit" class="btn btn-sm btn-<?php echo e($warna); ?>" fw-bold><?php echo e(ucwords($data?->status)); ?> </button>  
                                    </form>
                                </td>
                                <td class="align-middle">
                                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#update-<?php echo e($data?->id); ?>" class="btn btn-icon btn-sm btn-outline btn-outline-info text-hover-white">
                                        <i class="bi bi-pencil text-info fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Update"></i>
                                    </a>
                                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#delete-<?php echo e($data?->id); ?>" class="btn btn-icon btn-sm btn-outline btn-outline-danger text-hover-white">
                                        <i class="bi bi-trash text-danger fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Hapus"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php echo $__env->make('admin.menu.item.modal-update', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php echo $__env->make('admin.menu.item.modal-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('admin.menu.item.modal-store', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/dataTables.bootstrap5.min.js"></script>
<script>
    $(document).ready(function () {
        $('#datatable').DataTable({
            // "lengthMenu": [ [25, 50, 100, -1], [25, 50, 100, "All"] ],
            // "iDisplayLength": 25
        });
    });

    
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\desaid\resources\views/admin/menu/index.blade.php ENDPATH**/ ?>