<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Pengumuman;
use App\Models\Profil;
use App\Models\RefSK;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;
use RealRashid\SweetAlert\Facades\Alert;

class PengumumanController extends Controller
{
    public function index(){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $refsks = RefSK::all();
        $datas = Pengumuman::all();
        return view('admin.pengumuman.index',[
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
            'datas' => $datas,
        ])->with('tittle', 'Pengumuman');
    }

    public function store(Request $request){
        $request->validate([
            'judul'      => 'required|string|max:255',
            'file'      => 'required|mimes:png,jpg,pdf|max:2048',
        ]);

        $input = $request->all();
        if (empty($request->file)) {
            $nama_file = NULL;
        } else {
            $image = $request->file('file');
            $nama_file = Str::slug($request->judul, '-').'.'.$image->getClientOriginalExtension();
            $tujuan_upload = public_path('../public/assets/images/pengumuman');
            $image->move($tujuan_upload,$nama_file);
        }
        $input['file'] = $nama_file;
        $input['slug_judul'] = Str::slug($request->judul, '-');

        $simpan = Pengumuman::create($input);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-pengumuman-index');
    }

    public function update(Request $request){
        // return $request;
        $request->validate([
            'judul'      => 'required|string|max:255',
            // 'file'      => 'required|mimes:png,jpg',
        ]);

        $data = Pengumuman::where('id', $request->id)->first();
        
        if (empty($request->file)) {
            $nama_file = $data->file;
        } else {
            $image = $request->file('file');
            $nama_file = Str::slug($request->judul, '-').'.'.$image->getClientOriginalExtension();
            $tujuan_upload = public_path('../public/assets/images/pengumuman');
            $image->move($tujuan_upload,$nama_file);

            $lokasi = $tujuan_upload.'/'.$data->file;
            if(File::exists($lokasi)) {
                File::delete($lokasi);
            }
        }

        $simpan = Pengumuman::where('id', $request->id)->update([
            'judul' => $request->judul,
            'slug_judul' => Str::slug($request->judul, '-'),
            'file' => $nama_file,
            'deskripsi' => $request->deskripsi,
        ]);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-pengumuman-index');
    }

    public function delete($id){
        $data = Pengumuman::where('id', $id)->first();
        $direktori = public_path('../public/assets/images/pengumuman');
        $lokasi = $direktori.'/'.$data->file;
        if(File::exists($lokasi)) {
            File::delete($lokasi);
        }
        $eksekusi = Pengumuman::where('id', $id)->delete();

        if ($eksekusi) {
            Alert::success('Berhasil', 'Data Telah Dihapus');
        } else {
            Alert::error('Gagal', 'Data Tidak Dihapus');
        }

        return redirect()->route('admin-pengumuman-index');
    }
}
