<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Perangkat;
use App\Models\Profil;
use App\Models\RefSK;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

class PerangkatController extends Controller
{
    public function index($kelompok){
        if($kelompok=="desa"){
            $judul="Perangkat Desa";
        }elseif($kelompok=="bpd"){
            $judul="Anggota BPD";
        }elseif($kelompok=="pkk"){
            $judul="Anggota PKK";
        }else{
            $judul="Karang Taruna";
        }
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $datas = Perangkat::where('kelompok', $kelompok)->get();
        $refsks = RefSK::all();
        return view('admin.perangkat.index',[
            'kelompok' => $kelompok,
            'judul' => $judul,
            'datas' => $datas,
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
        ])->with('tittle', $judul);
    }

    public function add($kelompok){
        if($kelompok=="desa"){
            $judul="Perangkat Desa";
        }elseif($kelompok=="bpd"){
            $judul="Anggota BPD";
        }elseif($kelompok=="pkk"){
            $judul="Anggota PKK";
        }else{
            $judul="Karang Taruna";
        }
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $datas = Perangkat::where('jenis', $kelompok);
        $refsks = RefSK::all();
        return view('admin.perangkat.add',[
            'kelompok' => $kelompok,
            'judul' => $judul,
            'datas' => $datas,
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
        ])->with('tittle', $judul);
    }

    public function store(Request $request, $kelompok){
        $request->validate([
            'kelompok'      => 'required|string',
            'jabatan'       => 'required|string',
            'nik'           => 'required|string|max:16',
            'nomor_induk'   => 'required|string|max:20',
            'nama'          => 'required|string',
            'tempat_lahir'  => 'required|string',
        ]);

        $input = $request->all();
        // $input['nama'] = strtoupper($request->nama);
        $input['tempat_lahir'] = strtoupper($request->tempat_lahir);
        if (empty($request->foto)) {
            $nama_file = NULL;
        } else {
            $image = $request->file('foto');
            $nama_file = date('dmYHis').'.'.$image->getClientOriginalExtension();
            $tujuan_upload = public_path('../public/assets/images/perangkat');
            $image->move($tujuan_upload,$nama_file);
        }
        $input['foto'] = $nama_file;

        $simpan = Perangkat::create($input);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-perangkat-index',['kelompok'=>$kelompok]);
    }

    public function edit($kelompok,$id){
        if($kelompok=="desa"){
            $judul="Perangkat Desa";
        }elseif($kelompok=="bpd"){
            $judul="Anggota BPD";
        }elseif($kelompok=="pkk"){
            $judul="Anggota PKK";
        }else{
            $judul="Karang Taruna";
        }
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $data = Perangkat::where('id', $id)->first();
        $refsks = RefSK::all();
        return view('admin.perangkat.edit',[
            'kelompok' => $kelompok,
            'judul' => $judul,
            'data' => $data,
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
        ])->with('tittle', $judul);
    }

    public function update(Request $request, $kelompok){
        $request->validate([
            'kelompok'      => 'required|string',
            'jabatan'       => 'required|string',
            'nik'           => 'required|string|max:16',
            'nomor_induk'   => 'required|string|max:20',
            'nama'          => 'required|string',
            'tempat_lahir'  => 'required|string',
        ]);

        $data = Perangkat::where('id', $request->id)->first();

        if (empty($request->foto)) {
            $nama_file = $data->foto;
        } else {
            $image = $request->file('foto');
            $nama_file = date('dmYHis').'.'.$image->getClientOriginalExtension();
            $tujuan_upload = public_path('../public/assets/images/perangkat');
            $image->move($tujuan_upload,$nama_file);

            $lokasi = $tujuan_upload.'/'.$data->foto;
            if(File::exists($lokasi)) {
                File::delete($lokasi);
            }
        }
        
        $simpan = Perangkat::where('id', $request->id)->update([
            'kelompok' => $request->kelompok,
            'jabatan' => $request->jabatan,
            'nik' => $request->nik,
            'nomor_induk' => $request->nomor_induk,
            'nama' => $request->nama,
            'tempat_lahir' => $request->tempat_lahir,
            'tgl_lahir' => $request->tgl_lahir,
            'no_tlp' => $request->no_tlp,
            'alamat' => $request->alamat,
            'foto' => $nama_file,
        ]);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-perangkat-index',['kelompok'=>$kelompok]);
    }

    public function delete($kelompok,$id){
        $data = Perangkat::where('id', $id)->first();
        $direktori = public_path('../public/assets/images/berita');
        $lokasi = $direktori.'/'.$data->foto;
        if(File::exists($lokasi)) {
            File::delete($lokasi);
        }
        $eksekusi = Perangkat::where('id', $id)->delete();

        if ($eksekusi) {
            Alert::success('Berhasil', 'Data Telah Dihapus');
        } else {
            Alert::error('Gagal', 'Data Tidak Dihapus');
        }

        return redirect()->route('admin-perangkat-index',['kelompok'=>$kelompok]);
    }
}
