@php
    use App\Models\Surat;
@endphp
@if ($jenis=="kwitansi")
<div class="modal fade" id="kwitansi-update-{{ $kwitansi->id }}" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <!--begin::Modal content-->
        <div class="modal-content">
            <!--begin::Modal header-->
            <div class="modal-header">
                <!--begin::Modal title-->
                <h2>Form Edit {{ $tittle }}</h2>
                <!--end::Modal title-->
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                    <span class="svg-icon svg-icon-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="black" />
                            <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="black" />
                        </svg>
                    </span>
                    <!--end::Svg Icon-->
                </div>
                <!--end::Close-->
            </div>
            <!--end::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y mx-2 mx-xl-5 my-3">
                @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <!--begin::Form-->
                <form type="POST" action="{{ route('admin-surat-update', ['jenis'=>$jenis,'id' => $kwitansi->id]) }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <!--begin::Input group-->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Nomor Surat Tugas</span>
                                </label>
                                <select name="surat_id" id="surat_id" class="form-control form-select{{ $errors->has('surat_id') ? ' is-invalid' : '' }}">
                                    @php
                                        $surats = Surat::where('jenis','perintah')->orderBy('tgl_surat','desc')->get();
                                    @endphp
                                    @foreach ($surats as $surat)
                                    <option value="{{ $surat->id }}" {{ $kwitansi->surat_id==$surat->id ? 'selected' : '' }}>{{ $surat->nomor }} ({{ date('d-m-Y', strtotime($surat->tgl_surat)) }})</option>
                                    @endforeach
                                </select>
                                @if($errors->has('surat_id'))
                                    <span class="invalid-feedback">{{ $errors->first('surat_id') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Pegawai DL</span>
                                </label>
                                <select name="pegawai_id" id="pegawai_id" class="form-control form-select{{ $errors->has('pegawai_id') ? ' is-invalid' : '' }}">
                                    @foreach ($pegawais as $pegawai)
                                    <option value="{{ $pegawai->id }}" {{ $kwitansi->pegawai_id==$pegawai->id ? 'selected' : '' }}>{{ $pegawai->nama }}</option>
                                    @endforeach
                                </select>
                                @if($errors->has('pegawai_id'))
                                    <span class="invalid-feedback">{{ $errors->first('pegawai_id') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Tanggal Kwitansi</span>
                                </label>
                                <input type="date" class="form-control" name="tgl_kwitansi" id="tgl_kwitansi" value="{{ $kwitansi->tgl_kwitansi }}"/>
                                @if($errors->has('tgl_kwitansi'))
                                    <span class="invalid-feedback">{{ $errors->first('tgl_kwitansi') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Uang harian</span>
                                </label>
                                <input type="number" class="form-control" name="uang_harian" id="uang_harian" value="{{ $kwitansi->uang_harian }}"/>
                                @if($errors->has('uang_harian'))
                                    <span class="invalid-feedback">{{ $errors->first('uang_harian') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Uang Transport</span>
                                </label>
                                <input type="number" class="form-control" name="transport" id="transport" value="{{ $kwitansi->transport }}"/>
                                @if($errors->has('transport'))
                                    <span class="invalid-feedback">{{ $errors->first('transport') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Akomodasi/Penginapan</span>
                                </label>
                                <input type="number" class="form-control" name="penginapan" id="penginapan" value="{{ $kwitansi->penginapan }}"/>
                                @if($errors->has('penginapan'))
                                    <span class="invalid-feedback">{{ $errors->first('penginapan') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Uang Representatif</span>
                                </label>
                                <input type="number" class="form-control" name="representatif" id="representatif" value="{{ $kwitansi->representatif }}"/>
                                @if($errors->has('representatif'))
                                    <span class="invalid-feedback">{{ $errors->first('representatif') }}</span>
                                @endif
                            </div>
                        </div>
                        {{-- @if (!empty($kwitansi->eviden))    
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="">Eviden Terupload</span>
                                </label>
                                <div class="row">
                                    <?php
                                        $decode = json_decode($kwitansi?->eviden);
                                    ?>
                                    @foreach ($decode as $foto)
                                    <div class="col-md-4">
                                        <img class="img-fluid image" src="{{asset('assets/images/sppd/'.$foto.'')}}" width="100" height="100" style="object-fit:cover; margin:5px;">
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                        @endif --}}
                        <div class="col-md-12">
                            <div class="form-group mb-7">
                                <label class="required form-label">Unggah Ulang Bukti Biaya</label>
                                <div class="file-loading">
                                    <label>Preview File Icon</label>
                                    <input id="file-4" type="file" name="eviden[]" class="form-control{{ $errors->has('eviden') ? ' is-invalid' : '' }}" multiple>
                                    @if($errors->has('eviden'))
                                        <span class="invalid-feedback">{{ $errors->first('eviden') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div><hr>
                    <!--begin::Actions-->
                    <div class="text-center pt-2">
                        <button type="reset" class="btn btn-danger">
                            <span class="indicator-label">Batal</span>
                        </button>
                        <button type="submit" class="btn btn-primary">
                            <span class="indicator-label">Simpan</span>
                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end::Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>
@elseif($jenis=="masuk")
<div class="modal fade" id="masuk-update-{{ $data->id }}" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-dialog-centered modal-xl">
        <!--begin::Modal content-->
        <div class="modal-content">
            <!--begin::Modal header-->
            <div class="modal-header">
                <!--begin::Modal title-->
                <h2>Form Edit {{ $tittle }}</h2>
                <!--end::Modal title-->
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                    <span class="svg-icon svg-icon-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="black" />
                            <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="black" />
                        </svg>
                    </span>
                    <!--end::Svg Icon-->
                </div>
                <!--end::Close-->
            </div>
            <!--end::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y mx-2 mx-xl-5 my-3">
                @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <!--begin::Form-->
                <form type="POST" action="{{ route('admin-surat-update',['jenis'=>$jenis,'id' => $data->id]) }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <!--begin::Input group-->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Perihal Surat</span>
                                </label>
                                <textarea type="text" class="form-control" name="perihal" id="perihal" placeholder="Masukan disini!" rows="2">{{ $data->perihal }}</textarea>
                                @if($errors->has('perihal'))
                                    <span class="invalid-feedback">{{ $errors->first('perihal') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Nomor Surat</span>
                                </label>
                                <input type="text" class="form-control" name="nomor" id="nomor" placeholder="Masukan disini!" value="{{ $data->nomor }}"/>
                                @if($errors->has('nomor'))
                                    <span class="invalid-feedback">{{ $errors->first('nomor') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Tanggal Surat</span>
                                </label>
                                <input type="date" class="form-control" name="tgl_surat" id="tgl_surat" placeholder="Masukan disini!" value="{{ $data->tgl_surat }}"/>
                                @if($errors->has('tgl_surat'))
                                    <span class="invalid-feedback">{{ $errors->first('tgl_surat') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Tanggal Diterima</span>
                                </label>
                                <input type="date" class="form-control" name="tgl_terima" id="tgl_terima" placeholder="Masukan disini!" value="{{ $data->tgl_terima }}"/>
                                @if($errors->has('tgl_terima'))
                                    <span class="invalid-feedback">{{ $errors->first('tgl_terima') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Pengirim Surat</span>
                                </label>
                                <textarea type="text" class="form-control" name="asal_surat" id="asal_surat" placeholder="Masukan disini!" rows="2">{{ $data->asal_surat }}</textarea>
                                @if($errors->has('asal_surat'))
                                    <span class="invalid-feedback">{{ $errors->first('asal_surat') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="">File Terupload</span>
                                </label>
                                <embed src="{{ asset('assets/images/surat/masuk/'.$data->file.'') }}" width="100%" height="150" alt="pdf" />
                                <input type="text" class="form-control" name="file_awal" id="file_awal" placeholder="Masukan disini!" value="{{ $data->file }}"/>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="">Upload Ulang</span>
                                </label>
                                <input type="file" class="form-control" name="file" id="file" placeholder="Masukan disini!" value="{{ old('file') }}"/>
                                @if($errors->has('file'))
                                    <span class="invalid-feedback">{{ $errors->first('file') }}</span>
                                @endif
                            </div>
                        </div>
                    </div><hr>
                    <!--begin::Actions-->
                    <div class="text-center pt-2">
                        <button type="reset" class="btn btn-danger">
                            <span class="indicator-label">Batal</span>
                        </button>
                        <button type="submit" class="btn btn-primary">
                            <span class="indicator-label">Simpan</span>
                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end::Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>
@elseif($jenis=="keluar")
<div class="modal fade" id="keluar-update-{{ $data?->id }}" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-dialog-centered modal-xl">
        <!--begin::Modal content-->
        <div class="modal-content">
            <!--begin::Modal header-->
            <div class="modal-header">
                <!--begin::Modal title-->
                <h2>Form Edit {{ $tittle }}</h2>
                <!--end::Modal title-->
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                    <span class="svg-icon svg-icon-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="black" />
                            <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="black" />
                        </svg>
                    </span>
                    <!--end::Svg Icon-->
                </div>
                <!--end::Close-->
            </div>
            <!--end::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y mx-2 mx-xl-5 my-3">
                @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <!--begin::Form-->
                <form type="POST" action="{{ route('admin-surat-update',['jenis'=>$jenis,'id' => $data->id]) }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <!--begin::Input group-->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Perihal Surat</span>
                                </label>
                                <textarea type="text" class="form-control" name="perihal" id="perihal" placeholder="Masukan disini!" rows="2">{{ $data->perihal }}</textarea>
                                @if($errors->has('perihal'))
                                    <span class="invalid-feedback">{{ $errors->first('perihal') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Nomor Surat</span>
                                </label>
                                <input type="text" class="form-control" name="nomor" id="nomor" placeholder="Masukan disini!" value="{{ $data->nomor }}"/>
                                @if($errors->has('nomor'))
                                    <span class="invalid-feedback">{{ $errors->first('nomor') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Tanggal Surat</span>
                                </label>
                                <input type="date" class="form-control" name="tgl_surat" id="tgl_surat" placeholder="Masukan disini!" value="{{ $data->tgl_surat }}"/>
                                @if($errors->has('tgl_surat'))
                                    <span class="invalid-feedback">{{ $errors->first('tgl_surat') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Penerima Surat</span>
                                </label>
                                <textarea type="text" class="form-control" name="tujuan_surat" id="tujuan_surat" placeholder="Masukan disini!" rows="2">{{ $data->tujuan_surat }}</textarea>
                                @if($errors->has('tujuan_surat'))
                                    <span class="invalid-feedback">{{ $errors->first('tujuan_surat') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="">File Terupload</span>
                                </label>
                                <embed src="{{ asset('assets/images/surat/keluar/'.$data->file.'') }}" width="100%" height="150" alt="pdf" />
                                <input type="text" class="form-control" name="file_awal" id="file_awal" placeholder="Masukan disini!" value="{{ $data->file }}"/>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="">Upload Ulang</span>
                                </label>
                                <input type="file" class="form-control" name="file" id="file" placeholder="Masukan disini!" value="{{ old('file') }}"/>
                                @if($errors->has('file'))
                                    <span class="invalid-feedback">{{ $errors->first('file') }}</span>
                                @endif
                            </div>
                        </div>
                    </div><hr>
                    <!--begin::Actions-->
                    <div class="text-center pt-2">
                        <button type="reset" class="btn btn-danger">
                            <span class="indicator-label">Batal</span>
                        </button>
                        <button type="submit" class="btn btn-primary">
                            <span class="indicator-label">Simpan</span>
                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end::Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>
@else
<div class="modal fade" id="dl-update-{{ $data->id }}" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-dialog-centered modal-xl">
        <!--begin::Modal content-->
        <div class="modal-content">
            <!--begin::Modal header-->
            <div class="modal-header">
                <!--begin::Modal title-->
                <h2>Form Edit {{ $tittle }}</h2>
                <!--end::Modal title-->
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                    <span class="svg-icon svg-icon-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="black" />
                            <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="black" />
                        </svg>
                    </span>
                    <!--end::Svg Icon-->
                </div>
                <!--end::Close-->
            </div>
            <!--end::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y mx-5 mx-xl-5 my-7">
                @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <!--begin::Form-->
                <form type="POST" action="{{ route('admin-surat-update', ['jenis'=>$jenis,'id' => $data->id]) }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <!--begin::Input group-->
                    <div class="row">
                        <div class="col-md-3">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Tanggal Surat</span>
                                </label>
                                <input type="date" class="form-control" name="tgl_surat" id="tgl_surat" value="{{ $data->tgl_surat }}"/>
                                @if($errors->has('tgl_surat'))
                                    <span class="invalid-feedback">{{ $errors->first('tgl_surat') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Nomor Surat</span>
                                </label>
                                <input type="text" class="form-control" name="nomor" id="nomor" value="{{ $data->nomor }}"/>
                                @if($errors->has('nomor'))
                                    <span class="invalid-feedback">{{ $errors->first('nomor') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Pemberi Perintah</span>
                                </label>
                                <select name="pegawai_dl_ttd" id="pegawai_dl_ttd" class="form-control form-select{{ $errors->has('pegawai_dl_ttd') ? ' is-invalid' : '' }}">
                                    @foreach ($pegawais as $pegawai)
                                    <option value="{{ $pegawai->id }}" {{ $data->pegawai_dl_ttd==$pegawai->id ? 'selected' : '' }}>{{ $pegawai->nama }} - {{ $pegawai->jabatan }}</option>
                                    @endforeach
                                </select>
                                @if($errors->has('pegawai_dl_ttd'))
                                    <span class="invalid-feedback">{{ $errors->first('pegawai_dl_ttd') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Dasar Surat</span>
                                </label>
                                <textarea type="text" class="form-control" name="dasar_surat_dl" id="dasar_surat_dl" rows="4">{{ $data->dasar_surat_dl }}</textarea>
                                @if($errors->has('dasar_surat_dl'))
                                    <span class="invalid-feedback">{{ $errors->first('dasar_surat_dl') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Tujuan DL</span>
                                </label>
                                <textarea type="text" class="form-control" name="tujuan_dl" id="tujuan_dl" rows="4">{{ $data->tujuan_dl }}</textarea>
                                @if($errors->has('tujuan_dl'))
                                    <span class="invalid-feedback">{{ $errors->first('tujuan_dl') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Pegawai DL</span>
                                </label>
                                <select name="pegawai_dl[]" id="pegawai_dl" multiple class="form-control form-select{{ $errors->has('pegawai_dl') ? ' is-invalid' : '' }}">
                                    @php
                                        $dl = json_decode($data?->pegawai_dl);
                                    @endphp
                                    @foreach ($pegawais as $pegawai)
                                    <option value="{{ $pegawai->id }}" {{ in_array($pegawai->id, $dl) ? 'selected' : ''  }}>{{ $pegawai->nama }} - {{ $pegawai->jabatan }}</option>
                                    @endforeach
                                </select>
                                @if($errors->has('pegawai_dl'))
                                    <span class="invalid-feedback">{{ $errors->first('pegawai_dl') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Tempat DL</span>
                                </label>
                                <textarea type="text" class="form-control" name="tempat_dl" id="tempat_dl" rows="2">{{ $data->tempat_dl }}</textarea>
                                @if($errors->has('tempat_dl'))
                                    <span class="invalid-feedback">{{ $errors->first('tempat_dl') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Kota/Kab/Kec Tempat DL</span>
                                </label>
                                <input type="text" class="form-control" name="kota_dl" id="kota_dl" value="{{ $data->kota_dl }}"/>
                                @if($errors->has('kota_dl'))
                                    <span class="invalid-feedback">{{ $errors->first('kota_dl') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Angkutan yang digunakan</span>
                                </label>
                                <input type="text" class="form-control" name="angkutan_dl" id="angkutan_dl" value="{{ $data->angkutan_dl }}"/>
                                @if($errors->has('angkutan_dl'))
                                    <span class="invalid-feedback">{{ $errors->first('angkutan_dl') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Kode Rekening Anggaran</span>
                                </label>
                                <input type="text" class="form-control" name="rek_anggaran_dl" id="rek_anggaran_dl" value="{{ $data->rek_anggaran_dl }}"/>
                                @if($errors->has('rek_anggaran_dl'))
                                    <span class="invalid-feedback">{{ $errors->first('rek_anggaran_dl') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Tanggal Berangkat</span>
                                </label>
                                <input type="date" class="form-control" name="tgl_berangkat_dl" id="tgl_berangkat_dl" value="{{ $data->tgl_berangkat_dl }}"/>
                                @if($errors->has('tgl_berangkat_dl'))
                                    <span class="invalid-feedback">{{ $errors->first('tgl_berangkat_dl') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Tanggal Pulang</span>
                                </label>
                                <input type="date" class="form-control" name="tgl_pulang_dl" id="tgl_pulang_dl" value="{{ $data->tgl_pulang_dl }}"/>
                                @if($errors->has('tgl_pulang_dl'))
                                    <span class="invalid-feedback">{{ $errors->first('tgl_pulang_dl') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Waktu</span>
                                </label>
                                <input type="time" class="form-control" name="waktu_dl" id="waktu_dl" value="{{ $data->waktu_dl }}"/>
                                @if($errors->has('waktu_dl'))
                                    <span class="invalid-feedback">{{ $errors->first('waktu_dl') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span>Keterangan Lainnya</span><i>(Opsional)</i>
                                </label>
                                <textarea type="text" class="form-control" name="ket" id="ket" rows="2" placeholder="Masukan disini!">{{ $data->ket }}</textarea>
                                @if($errors->has('ket'))
                                    <span class="invalid-feedback">{{ $errors->first('ket') }}</span>
                                @endif
                            </div>
                        </div>
                    </div><hr>
                    <!--end::Input group-->
                    <!--begin::Actions-->
                    <div class="text-center pt-2">
                        <button type="reset" class="btn btn-danger">
                            <span class="indicator-label">Batal</span>
                        </button>
                        <button type="submit" class="btn btn-primary">
                            <span class="indicator-label">Simpan</span>
                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end::Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>
@endif