<div class="modal fade" id="update-<?php echo e($data->id); ?>" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-dialog-centered modal-xl">
        <!--begin::Modal content-->
        <div class="modal-content">
            <!--begin::Modal header-->
            <div class="modal-header">
                <!--begin::Modal title-->
                <h2>Form Edit <?php echo e($tittle); ?></h2>
                <!--end::Modal title-->
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                    <span class="svg-icon svg-icon-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="black" />
                            <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="black" />
                        </svg>
                    </span>
                    <!--end::Svg Icon-->
                </div>
                <!--end::Close-->
            </div>
            <!--end::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y mx-2 mx-xl-5 my-2">
                <?php if(count($errors) > 0): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <?php endif; ?>
                <!--begin::Form-->
                <form type="POST" action="<?php echo e(route('admin-infopublik-update', ['id' => $data->id])); ?>" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <!--begin::Input group-->
                    <div class="row">
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Pilih Kategori</span>
                                </label>
                                <select name="kategori_id" id="kategori_id" class="form-control form-select<?php echo e($errors->has('kategori_id') ? ' is-invalid' : ''); ?>">
                                    <?php $__currentLoopData = $kategoris; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kategori): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($kategori->id); ?>" <?php echo e($data->kategori_id==$kategori->id ? 'selected' : ''); ?>><?php echo e($kategori->nama); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php if($errors->has('kategori_id')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('kategori_id')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Tahun</span>
                                </label>
                                <input type="number" name="tahun" id="tahun" class="form-control<?php echo e($errors->has('tahun') ? ' is-invalid' : ''); ?>" value=<?php echo e($data->tahun); ?>>
                                <?php if($errors->has('tahun')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('tahun')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-7">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Judul</span>
                                </label>
                                <input type="text" name="judul" id="judul" class="form-control<?php echo e($errors->has('judul') ? ' is-invalid' : ''); ?>" value=<?php echo e($data->judul); ?>>
                                <?php if($errors->has('judul')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('judul')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="">File</span>
                                </label>
                                <input type="file" name="file" id="file" class="form-control<?php echo e($errors->has('file') ? ' is-invalid' : ''); ?>">
                                <?php if($errors->has('file')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('file')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="">File Terupload - <u class="text-primary"><?php echo e($data->file); ?></u></span>
                                </label>
                                <iframe src="<?php echo e(asset('assets/images/informasipublik/'.$data->file.'')); ?>" width="100px" height="100px"></iframe>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="">Keterangan</span>
                                </label>
                                <textarea name="deskripsi" id="deskripsi" class="form-control<?php echo e($errors->has('deskripsi') ? ' is-invalid' : ''); ?>" rows="5"><?php echo e($data->deskripsi); ?></textarea>
                                <?php if($errors->has('deskripsi')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('deskripsi')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <!--end::Input group-->
                    <!--begin::Actions-->
                    <div class="text-center pt-5">
                        
                        <button type="submit" class="btn btn-primary">
                            <span class="indicator-label">Simpan</span>
                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end::Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div><?php /**PATH /home/pand6342/public_html/panyutran.desa.ids/resources/views/admin/informasipublik/item/modal-update.blade.php ENDPATH**/ ?>