<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Profil;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Requests\PenggunaRequest;
use App\Models\RefSK;
use Illuminate\Support\Facades\Auth;
use RealRashid\SweetAlert\Facades\Alert;

class PenggunaController extends Controller
{
    public function index(){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        if($level=="admin"){
            $datas = User::where('id', '>', 1)->get();
        }else{
            $datas = User::where('id', Auth::user()->id)->get();
        }
        $refsks = RefSK::all();
        return view('admin.pengguna.index',[
            'datas' => $datas,
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
        ])->with('tittle', 'Pengelolaan Pengguna');
    }

    public function store(PenggunaRequest $request){
        $input = $request->all();
        $input['password'] = bcrypt($request->password);
        $input['status'] = "Aktif";
        $simpan = User::create($input);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-pengguna-index');
    }

    public function update(PenggunaRequest $request, $id){
        $simpan = User::where('id', $id)->update([
            'name' => $request->name,
            'email' => $request->email,
            'username' => $request->username,
            'level' => $request->level,
            'status' => $request->status,
            'updated_at' => $request->updated_at,
        ]);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-pengguna-index');
    }

    public function delete($id) {
        $hapusdata = User::where('id', $id)->delete();

        if ($hapusdata) {
            Alert::success('Berhasil', 'Data Telah Dihapus');
        } else {
            Alert::error('Gagal', 'Data Tidak Dihapus');
        }

        return redirect()->route('admin-pengguna-index');
    }

    public function update_password(Request $request, $id){
        $level = Auth::user()->level;
        $simpan = User::where('id', $id)->update([
            'password' => bcrypt($request->password),
        ]);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route(''.$level.'-pengguna-index');
    }

    public function update_status(Request $request, $id){
        $simpan = User::where('id', $id)->update([
            'status' => $request->status,
        ]);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-pengguna-index');
    }
}
