<?php
    use App\Models\Perangkat;
    use App\Models\Surat;
?>

<?php $__env->startSection('css'); ?>
<link href="https://cdn.datatables.net/1.13.1/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />
<link href="<?php echo e(asset('assets/fileinput/css/fileinput.css')); ?>" media="all" rel="stylesheet" type="text/css"/>
<link href="<?php echo e(asset('assets/fileinput/themes/explorer-fas/theme.css')); ?>" media="all" rel="stylesheet" type="text/css"/>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/baguettebox.js/1.10.0/baguetteBox.min.css"/>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!--begin::Toolbar-->
<div class="toolbar mt-2" id="kt_toolbar">
    <!--begin::Container-->
    <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
        <!--begin::Page title-->
        <div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
            <!--begin::Title-->
            <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1"><?php echo e($tittle); ?></h1>
            <!--end::Title-->
            <!--begin::Separator-->
            <span class="h-20px border-gray-300 border-start mx-4"></span>
            <!--end::Separator-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="<?php echo e(route('admin-dashboard')); ?>" class="text-muted text-hover-primary">Beranda</a>
                </li>
                <!--end::Item-->
                <!--begin::Item-->
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-300 w-5px h-2px"></span>
                </li>
                <!--end::Item-->
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted"><?php echo e($tittle); ?></li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
    </div>
</div>
<!--begin::Post-->
<div class="post d-flex flex-column-fluid mt-0">
    <?php if(count($errors) > 0): ?>
    <div class="alert alert-danger">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
    <?php endif; ?>
    <!--begin::Container-->
    <?php if($jenis=='perintah'): ?>
    <div class="container">
        <!--begin::Pricing card-->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">List <?php echo e($tittle); ?></span>
                </h3>
                <div class="card-toolbar">
                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#dl-store" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tambah</a>
                    
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <table id="datatable" class="table table-striped table-row-bordered gy-4 gs-7 border rounded">
                    <thead>
                        <tr class="fw-bolder bg-secondary fs-6 text-gray-800 px-7">
                            <th width="5%" class="align-middle">No</th>
                            <th class="align-middle text-center" width="15%">Opsi</th>
                            <th class="align-middle">No./Tanggal Surat</th>
                            <th class="align-middle">Pegawai TTD</th>
                            <th class="align-middle">Pegawai DL</th>
                            <th class="align-middle">Dasar DL</th>
                            <th class="align-middle">Tujuan DL</th>
                            <th class="align-middle">Tanggal DL</th>
                            <th class="align-middle">Waktu DL</th>
                            <th class="align-middle">Tempat DL</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $no=1;
                            $pegawai_ttd = Perangkat::where('id', $data?->pegawai_dl_ttd)->first();
                            $pegawai_dl = json_decode($data?->pegawai_dl);
                        ?>
                            <tr>
                                <td class="align-top"><?php echo e($loop->iteration); ?>.</td>
                                <td class="align-top">
                                    <a href="<?php echo e(route('admin-surat-cetak-st',['jenis'=>$jenis,'id'=>$data->id])); ?>" target="_blank" class="btn btn-icon btn-sm btn-outline btn-outline-warning text-hover-white mb-1">
                                        <i class="bi bi-printer text-warning fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Cetak Surat Tugas"></i>
                                    </a>
                                    <a href="<?php echo e(route('admin-surat-cetak-sppd',['jenis'=>$jenis,'id'=>$data->id])); ?>" target="_blank" class="btn btn-icon btn-sm btn-outline btn-outline-primary text-hover-white mb-1">
                                        <i class="bi bi-printer text-primary fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Cetak SPPD Depan"></i>
                                    </a>
                                    <a href="<?php echo e(route('admin-surat-cetak-sppd-2',['jenis'=>$jenis,'id'=>$data->id])); ?>" target="_blank" class="btn btn-icon btn-sm btn-outline btn-outline-dark text-hover-white mb-1">
                                        <i class="bi bi-printer text-dark fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Cetak SPPD Belakang"></i>
                                    </a><br>
                                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#dl-update-<?php echo e($data?->id); ?>" class="btn btn-icon btn-sm btn-outline btn-outline-info text-hover-white mb-1">
                                        <i class="bi bi-pencil text-info fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Update"></i>
                                    </a>
                                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#dl-delete-<?php echo e($data?->id); ?>" class="btn btn-icon btn-sm btn-outline btn-outline-danger text-hover-white mb-1">
                                        <i class="bi bi-trash text-danger fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Hapus"></i>
                                    </a>
                                </td>
                                <td class="align-top">
                                    <b>No. : </b><?php echo e($data?->nomor); ?><br>
                                    <b>Tanggal : </b><?php echo e(date('d-m-Y', strtotime($data?->tgl_surat))); ?>

                                </td>
                                <td class="align-top">
                                    <b>Nama: </b><?php echo e($pegawai_ttd?->nama); ?><br>
                                    <b>Jabatan: </b><?php echo e($pegawai_ttd?->jabatan); ?>

                                </td>
                                <td class="align-top">
                                    <?php
                                    foreach ($pegawai_dl as $id){
                                        $dl = Perangkat::where('id', $id)->first();
                                        echo "<b>Pegawai : </b>".$dl->nama."<br>
                                        <b>Jabatan : </b>".$dl->jabatan."<br><br>";
                                    }
                                    ?>
                                </td>
                                <td class="align-top"><?php echo e($data?->dasar_surat_dl); ?></td>
                                <td class="align-top"><?php echo e($data?->tujuan_dl); ?></td>
                                <td class="align-top">
                                    <b>Berangkat: </b><?php echo e(date('d-m-Y',strtotime($data?->tgl_berangkat_dl))); ?>

                                    <b>Pulang: </b><?php echo e(date('d-m-Y',strtotime($data?->tgl_pulang_dl))); ?>

                                </td>
                                <td class="align-top"><?php echo e($data?->waktu_dl); ?> s/d Selesai</td>
                                <td class="align-top"><?php echo e($data?->tempat_dl); ?></td>
                            </tr>
                            <?php echo $__env->make('admin.surat.item.dl-modal-update', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php echo $__env->make('admin.surat.item.dl-modal-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php elseif($jenis=='nota'): ?>
    <div class="container">
        <!--begin::Pricing card-->
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">List <?php echo e($tittle); ?></span>
                </h3>
                <div class="card-toolbar">
                    <a href="<?php echo e(route('admin-surat-tambah',['jenis'=>$jenis])); ?>" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tambah</a>
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <table id="datatable" class="table table-striped table-row-bordered gy-4 gs-7 border rounded">
                    <thead>
                        <tr class="fw-bolder bg-secondary fs-6 text-gray-800 px-7">
                            <th width="4%" class="align-middle">No</th>
                            <th class="align-middle text-center" width="15%">Opsi</th>
                            <th class="align-middle">Surat Tugas</th>
                            <th class="align-middle">Tanggal Nota Dinas</th>
                            <th class="align-middle">Penyelenggara</th>
                            <th class="align-middle">Acara/Kegiatan</th>
                            <th class="align-middle">Peserta</th>
                            <th class="align-middle">Hasil Kegiatan</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $notas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nota): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $jumlahkarakter=250;
                            $cetak = substr($nota->hasil, 0, $jumlahkarakter);

                            $st = Surat::where('id', $nota->surat_id)->first();
                        ?>
                        <tr>
                            <td class="align-top"><?php echo e($loop->iteration); ?>.</td>
                            <td class="align-top">
                                <a href="<?php echo e(route('admin-surat-cetak-nota',['jenis'=>$jenis,'id'=>$nota?->id])); ?>" target="_blank" class="btn btn-icon btn-sm btn-outline btn-outline-primary text-hover-white mb-1">
                                    <i class="bi bi-printer text-primary fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Cetak Nota Dinas"></i>
                                </a>
                                <a href="<?php echo e(route('admin-surat-edit', ['jenis'=>$jenis,'id' => $nota?->id])); ?>" class="btn btn-icon btn-sm btn-outline btn-outline-info text-hover-white mb-1">
                                    <i class="bi bi-pencil text-info fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Update"></i>
                                </a>
                                <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#nota-delete-<?php echo e($nota?->id); ?>" class="btn btn-icon btn-sm btn-outline btn-outline-danger text-hover-white mb-1">
                                    <i class="bi bi-trash text-danger fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Hapus"></i>
                                </a>
                            </td>
                            <td class="align-top">
                                <b>No. </b><?php echo e($st?->nomor); ?><br>
                                <b>Tanggal </b><?php echo e(date('d-m-Y', strtotime($st?->tgl_surat))); ?><br>
                            </td>
                            <td class="align-top">
                                <?php echo e(date('d-m-Y', strtotime($nota?->tgl_nota))); ?><br>
                                <?php
                                    $pegawai_dls = json_decode($st->pegawai_dl);
                                    if (!empty($pegawai_dls)) {
                                        $pegawai = Perangkat::where('id', $pegawai_dls[0])->first();
                                    } else {
                                        $pegawai = null;
                                    }
                                ?>
                                <b>Pegawai </b><?php echo e($pegawai->nama); ?> - <?php echo e($pegawai?->jabatan); ?>

                            </td>
                            <td class="align-top"><?php echo e($nota?->penyelenggara); ?></td>
                            <td class="align-top"><?php echo e($nota?->acara); ?></td>
                            <td class="align-top"><?php echo e($nota?->peserta); ?></td>
                            <td class="align-top"><?php echo $cetak;?></td>
                        </tr>
                        <?php echo $__env->make('admin.surat.item.dl-modal-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php elseif($jenis=='kwitansi'): ?>
    <div class="container">
        <!--begin::Pricing card-->
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">List <?php echo e($tittle); ?></span>
                </h3>
                <div class="card-toolbar">
                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#dl-store" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tambah</a>
                    
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <table id="datatable" class="table table-striped table-row-bordered gy-4 gs-7 border rounded">
                    <thead>
                        <tr class="fw-bolder bg-secondary fs-6 text-gray-800 px-7">
                            <th width="4%" class="align-middle">No</th>
                            <th class="align-middle text-center" width="15%">Opsi</th>
                            <th class="align-middle">Surat Tugas</th>
                            <th class="align-middle">Tanggal Kwitansi</th>
                            <th class="align-middle">Uang harian</th>
                            <th class="align-middle">Transport</th>
                            <th class="align-middle">Penginapan</th>
                            <th class="align-middle">Representatif</th>
                            <th class="align-middle">Eviden</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $kwitansis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kwitansi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            
                            if (empty($kwitansi->eviden)) {
                                $eviden = "noimage.png";
                            } else {
                                $eviden = $kwitansi?->eviden;
                            }
                            $st = Surat::where('id', $kwitansi->surat_id)->first();
                        ?>
                        <tr>
                            <td class="align-top"><?php echo e($loop->iteration); ?>.</td>
                            <td class="align-top">
                                <a href="<?php echo e(route('admin-surat-cetak-kwitansi',['jenis'=>$jenis,'id'=>$kwitansi?->id])); ?>" target="_blank" class="btn btn-icon btn-sm btn-outline btn-outline-primary text-hover-white mb-1">
                                    <i class="bi bi-printer text-primary fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Cetak Kwitansi Dinas"></i>
                                </a>
                                <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#kwitansi-update-<?php echo e($kwitansi?->id); ?>" class="btn btn-icon btn-sm btn-outline btn-outline-info text-hover-white mb-1">
                                    <i class="bi bi-pencil text-info fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Update"></i>
                                </a>
                                <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#kwitansi-delete-<?php echo e($kwitansi?->id); ?>" class="btn btn-icon btn-sm btn-outline btn-outline-danger text-hover-white mb-1">
                                    <i class="bi bi-trash text-danger fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Hapus"></i>
                                </a>
                            </td>
                            <td class="align-top">
                                <b>No. </b><?php echo e($st?->nomor); ?><br>
                                <b>Tanggal </b><?php echo e(date('d-m-Y', strtotime($st?->tgl_surat))); ?><br>    
                            </td>
                            <td class="align-top">
                                <?php echo e(date('d-m-Y', strtotime($kwitansi?->tgl_kwitansi))); ?><br>
                                <?php
                                    $pegawai = Perangkat::where('id', $kwitansi->pegawai_id)->first();
                                ?>
                                <b>Pegawai </b><?php echo e($pegawai->nama); ?> - <?php echo e($pegawai?->jabatan); ?>

                            </td>
                            <td class="align-top"><?php echo e($kwitansi?->uang_harian); ?></td>
                            <td class="align-top"><?php echo e($kwitansi?->transport); ?></td>
                            <td class="align-top"><?php echo e($kwitansi?->penginapan); ?></td>
                            <td class="align-top"><?php echo e($kwitansi?->representatif); ?></td>
                            <td class="align-middle">
                                <?php if(!empty($kwitansi->eviden)): ?>
                                <section class="compact-gallery">
                                    <?php
                                        $decode = json_decode($kwitansi->eviden);
                                    ?>
                                    <?php $__currentLoopData = $decode; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $foto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a class="lightbox" href="<?php echo e(asset('assets/images/sppd/'.$foto.'')); ?>">
                                            <img class="img-fluid image" src="<?php echo e(asset('assets/images/sppd/'.$foto.'')); ?>" width="50" height="50" style="object-fit:cover;">
                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </section>
                                <?php else: ?>
                                - 
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php echo $__env->make('admin.surat.item.dl-modal-update', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('admin.surat.item.dl-modal-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php else: ?>
    <div class="container">
        <!--begin::Pricing card-->
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">List <?php echo e($tittle); ?></span>
                </h3>
                <div class="card-toolbar">
                    
                    
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <img class="text-center" src="<?php echo e(asset('assets/images/coming-soon.avif')); ?>">
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php echo $__env->make('admin.surat.item.dl-modal-store', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/dataTables.bootstrap5.min.js"></script>

<!-- Fileinput -->
<script src="<?php echo e(asset('assets/fileinput/js/plugins/piexif.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/fileinput/js/plugins/sortable.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/fileinput/js/fileinput.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/fileinput/js/locales/fr.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/fileinput/js/locales/es.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/fileinput/themes/fas/theme.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/fileinput/themes/explorer-fas/theme.js')); ?>" type="text/javascript"></script>

<script>
    $(document).ready(function () {
        $('#datatable').DataTable({
            // "lengthMenu": [ [25, 50, 100, -1], [25, 50, 100, "All"] ],
            // "iDisplayLength": 25
        });
    });

    $("#file-3").fileinput({
        theme: 'fas',
        showUpload: false,
        showCaption: true,
        dropZoneEnabled: false,
        browseClass: "btn btn-primary btn-md",
        allowedFileExtensions: ["jpg", "jpeg", "png","pdf"],
        previewFileIcon: "<i class='glyphicon glyphicon-king'></i>",
        overwriteInitial: true,
        initialPreviewAsData: true,
        maxFileSize: 2048,
        // mainClass: "input-group",
    });
  
</script>
<script>
    $("#file-4").fileinput({
        rtl: true,
        theme: 'fas',
        showUpload: false,
        showCaption: true,
        dropZoneEnabled: false,
        browseClass: "btn btn-primary btn-md",
        allowedFileExtensions: ["jpg", "jpeg", "png"],
        previewFileIcon: "<i class='glyphicon glyphicon-king'></i>",
        overwriteInitial: true,
        initialPreviewAsData: true,
        maxFileSize: 2048,
        mainClass: "input-group",
    });  
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\desaid\resources\views/admin/surat/index.blade.php ENDPATH**/ ?>